unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ShellApi, System.ComponentModel, Borland.Vcl.StdCtrls,
  Borland.Vcl.AppEvnts, System.Text;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    ApplicationEvents1: TApplicationEvents;
    procedure ApplicationEvents1Message(var Msg: tagMSG; var Handled: Boolean);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.nfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
DragAcceptFiles(Handle,True);
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
DragAcceptFiles(Handle,False);
end;

procedure TForm1.ApplicationEvents1Message(var Msg: tagMSG;
  var Handled: Boolean);
var
   uchwyt :THandle; //uchwyt do struktury przechowujacej informacje o przenoszonych plikach
   LiczbaPlikow,i :Integer;
   NazwaPliku :StringBuilder;
begin
if Msg.message <> WM_DROPFILES then Exit;

uchwyt:=Msg.wParam;

//liczba zrzuconych plikw
LiczbaPlikow:=DragQueryFile(uchwyt,$FFFFFFFF,nil,0);

ListBox1.Items.Clear; //Czyszczenie listy przy kazdym upuszczeniu plikow
ListBox1.Items.Add('Czas operacji: '+DateTimeToStr(Now));
ListBox1.Items.Add('Ilosc plikow zrzuconych na forme: '+IntToStr(LiczbaPlikow));

NazwaPliku:=StringBuilder.Create(MAX_PATH);

for i:=0 to LiczbaPlikow-1 do
  begin
  DragQueryFile(uchwyt,i,NazwaPliku,NazwaPliku.Capacity);

  //tu okreslamy wlasciwe dzialanie zwiazane z upuszczeniem pliku
  //(mamy do dyspozycji nazwe pliku wraz ze sciezka w nazwa_pliku)
  ListBox1.Items.Add(NazwaPliku.ToString);
  end;

DragFinish(uchwyt); //zakonczenie procesu drag & drop
Handled:=True;
end;

end.
